﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using IndianHealthService.BMXNet.Model;
using IndianHealthService.BMXNet.WinForm;


namespace IndianHealthService.BMXNet.TestBench
{
    public partial class PatientVisitPicker : Form
    {
        public PatientVisitPicker()
        {
            InitializeComponent();
        }

        private DesktopSession _desktopSession = null;

        public DesktopSession DesktopSession
        {
            get { return _desktopSession; }
            set { _desktopSession = value; }
        }


        private Context _context;

        public Context Context
        {
            get { return _context; }
            set { _context = value; }
        }

        private Patient _selectedPatient = null;

        public Patient SelectedPatient
        {
            get { return _selectedPatient; }
            set { _selectedPatient = value; }
        }

        private void findByChartButton_Click(object sender, EventArgs e)
        {
            this.SelectedPatient = this.DesktopSession.FindPatientFromChart(this.patientEntry.Text.Trim(),false);
            this.UpdatePatientInfo();
        }

        public bool HasSelectedPatient
        {

            get { return this.SelectedPatient != null; }
        }

        private void findByIenButton_Click(object sender, EventArgs e)
        {
            this.CreateTestVisit();
        }

        private void CreateTestVisit()
        {
            if (this.HasSelectedPatient)
            {
              //  MessageBox.Show(this.Rpc.TransmitRPC("VEN WCM TEST VISIT", this.SelectedPatient..Text + ";1", "VEN RPC"));
            }
        }

        private void newVisitButton_Click(object sender, EventArgs e)
        {

        }

        private DesktopFramework _broker = null;

        public DesktopFramework Framework
        {
            get { return _broker; }
            set { _broker = value; }
        }

        
        private void okButton_Click(object sender, EventArgs e)
        {
            this.Framework.ChangePatient(this.SelectedPatient,false);
            this.Framework.ChangeVisit(this.SelectedVisit, false);
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        public Visit SelectedVisit
        {
            get
            {
                return (this.visitListView.SelectedItems.Count > 0)
                    ? this.visitListView.SelectedItems[0].Tag as Visit : null;
            }
        }
            
        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void PatientVisitPicker_Load(object sender, EventArgs e)
        {
           
            this.SelectedPatient = this.Context.Patient;
            this.UpdatePatientInfo();
        }

        public void UpdatePatientInfo()
        {
            this.patientLabel.Text = this.HasSelectedPatient ? this.SelectedPatient.PatientName : "[No patient found]";
            List<Visit> visits = new List<Visit>();
            if (this.HasSelectedPatient)
            {
                visits = this.DesktopSession.VisitsFor(this.SelectedPatient);
            }

            this.visitListView.BeginUpdate();
            this.visitListView.Columns.Clear();
            this.visitListView.Items.Clear();
            this.visitListView.Columns.Add("Date", 100);
            this.visitListView.Columns.Add("Clinic", 100);
            this.visitListView.Columns.Add("Provider", 150);
            foreach (Visit each in visits)
            {
                ListViewItem item = new ListViewItem(each.DateTime.ToShortDateString());
                item.SubItems.Add(each.LocationName);
                item.SubItems.Add(each.ProviderName);
                item.Tag = each;
                item.Selected = each.Ien == (this.Context.HasVisit ? this.Context.Visit.Ien : "");
                this.visitListView.Items.Add(item);
            }
            this.visitListView.EndUpdate();
        }

        private void patientEntry_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Return)
            {
                this.findByChartButton_Click(null, null);
                e.Handled = true;
            }
        }

        private void visitListView_DoubleClick(object sender, EventArgs e)
        {
            this.okButton_Click(null, null);
        }

        private void noVisitButton_Click(object sender, EventArgs e)
        {
            this.visitListView.SelectedItems.Clear();
        }

      

    }
}


